% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csg_construct.R
\name{csg_pyramid}
\alias{csg_pyramid}
\title{CSG Pyramid}
\usage{
csg_pyramid(x = 0, y = 0, z = 0, height = 1, base = 1)
}
\arguments{
\item{x}{Default `0`. x-coordinate on the pyramid.}

\item{y}{Default `0`. y-coordinate on the pyramid.}

\item{z}{Default `0`. z-coordinate on the pyramid.}

\item{height}{Default `1`. Pyramid height.}

\item{base}{Default `1`. Pyramid base width.}
}
\value{
List describing the box in the scene.
}
\description{
Note: This primitive slows down immensely for large values of base and height. Try using csg_scale()
with this object for large pyramids instead.
}
\examples{
if(run_documentation()) {
#Generate a simple pyramid:
generate_ground() \%>\% 
  add_object(csg_object(csg_pyramid(y=-0.99),
                        material=glossy(color="red"))) \%>\% 
  add_object(sphere(y=5,x=5,z=5,material=light(intensity=20))) \%>\% 
  render_scene(clamp_value=10, samples=16,lookfrom=c(-3,1,10), 
               fov=15, lookat=c(0,-0.5,0))
}
if(run_documentation()) {
#Make a taller pyramid
generate_ground() \%>\% 
  add_object(csg_object(csg_pyramid(y=-0.95, height=1.5),
                        material=glossy(color="red"))) \%>\% 
  add_object(sphere(y=5,x=5,z=5,material=light(intensity=20))) \%>\% 
  render_scene(clamp_value=10, samples=16,lookfrom=c(-3,1,10), 
               fov=15, lookat=c(0,-0.5,0))
  }
if(run_documentation()) {
#Make a wider pyramid
generate_ground() \%>\% 
  add_object(csg_object(csg_pyramid(y=-0.95, base=1.5),
                        material=glossy(color="red"))) \%>\% 
  add_object(sphere(y=5,x=5,z=5,material=light(intensity=20))) \%>\% 
  render_scene(clamp_value=10, samples=16,lookfrom=c(-3,1,10), 
               fov=15, lookat=c(0,-0.5,0))
}
}
