% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{text3d_mesh}
\alias{text3d_mesh}
\title{Text Object}
\usage{
text3d_mesh(
  label,
  position = c(0, 0, 0),
  text_height = 1,
  orientation = "xy",
  font_color = "black",
  font_size = 100,
  font = "sans",
  font_lineheight = 12,
  background_color = "white",
  background_alpha = 0,
  angle = c(0, 0, 0),
  pivot_point = c(0, 0, 0),
  order_rotation = c(1, 2, 3),
  scale = c(1, 1, 1)
)
}
\arguments{
\item{label}{Text string.}

\item{position}{Default \code{c(0,0,0)}. Position of the mesh.}

\item{text_height}{Default \code{1}. Height of the text.}

\item{orientation}{Default \code{xy}. Orientation of the plane. Other options are \code{yz} and \code{xz}.}

\item{font_color}{Default \code{"black"}. The font color.}

\item{font_size}{Default \code{100}. The size of the font. Note that this does not control the size of the text, just the resolution
as rendered in the texture.}

\item{font}{Default \code{"sans"}. A character string specifying the font family (e.g., \code{"Arial"}, \code{"Times"}, \code{"Helvetica"}).}

\item{font_lineheight}{Default \code{12}. The lineheight for strings with newlines.}

\item{background_color}{Default \code{"white"}. The background color.}

\item{background_alpha}{Default \code{0}. The background opacity. \code{1} is fully opaque.}

\item{angle}{Default \code{c(0,0,0)}. Angle to rotate the mesh.}

\item{pivot_point}{Default \code{c(0,0,0)}. Point around which to rotate the mesh.}

\item{order_rotation}{Default \code{c(1,2,3)}. Order to rotate the axes.}

\item{scale}{Default \code{c(1,1,1)}. Scale of the mesh. Can also be a single numeric value scaling all axes uniformly.}
}
\value{
List describing the mesh.
}
\description{
Text Object
}
\examples{
if(run_documentation()) {
#Generate a label in the Cornell box.
generate_cornell_mesh() |> 
  add_shape(text3d_mesh(label="Cornell Box", position=c(555/2,555/2,555/2),angle=c(0,180,0),
  text_height=120)) |> 
  rasterize_scene(light_info = directional_light(c(0.1,0.4,-1)))
}
if(run_documentation()) {
#Change the orientation
generate_cornell_mesh() |> 
  add_shape(text3d_mesh(label="YZ Plane", position=c(540,555/2,555/2),text_height=180,
                    orientation = "yz",angle=c(0,180,0))) |> 
  add_shape(text3d_mesh(label="XY Plane", position=c(555/2,555/2,540),text_height=180,
                    orientation = "xy", angle=c(0,180,0))) |> 
  add_shape(text3d_mesh(label="XZ Plane", position=c(555/2,15,555/2),text_height=180,
                    orientation = "xz", angle=c(0,180,0))) |> 
  rasterize_scene(light_info = directional_light(c(0.1,0.4,-1)))
  }
if(run_documentation()) {
#Add an label in front of a sphere and change the font
generate_cornell_mesh() |> 
  add_shape(text3d_mesh(label="Cornell Box", position=c(555/2,555/2,555/2),text_height=180,
                        font = "Serif", font_color="orange",
                        angle=c(0,180,0))) |> 
  add_shape(text3d_mesh(label="Sphere", position=c(555/2,130,100),text_height=100,
                        font = "sans",
                        font_color="lightblue",angle=c(0,180,40))) |> 
  add_shape(sphere_mesh(radius=100,position=c(555/2,100,555/2),
                        material=material_list(diffuse="purple",type="phong"))) |>                  
  rasterize_scene(light_info = directional_light(c(0.1,0.4,-1)))
  }
if(run_documentation()) {
#A room full of b's
set.seed(1)
bee_scene = list()
for(i in 1:100) {
bee_scene = add_shape(bee_scene, text3d_mesh("B", position=c(20+runif(3)*525), 
                                             font_color="yellow", text_height = 100,
                                             angle=c(0,180,0)))
}
generate_cornell_mesh() |> 
  add_shape(bee_scene) |>                   
  rasterize_scene(light=directional_light(c(0,1,-1)))
}

if(run_documentation()) {
#A room full of bees
bee_scene = list()
set.seed(1)
for(i in 1:100) {
  bee_scene = add_shape(bee_scene, text3d_mesh("\U1F41D", position=c(20+runif(3)*525), 
                                               font_color="yellow", text_height = 100,
                                               angle=c(0,180,0)))
}
generate_cornell_mesh() |> 
  add_shape(bee_scene) |>                   
  rasterize_scene(light=directional_light(c(0,1,-1)))
}
}
