% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMC.R
\name{MCMC.diagnostics}
\alias{MCMC.diagnostics}
\title{Test mixing and stationarity of the MCMC run}
\usage{
MCMC.diagnostics(set = get("info"), ssize = nrow(set$output))
}
\arguments{
\item{set}{Detailed information of the current run, stored within this session's memory as variable \code{info}.}

\item{ssize}{Number of MCMC iterations.}
}
\value{
The 'ess' and 'z' scores, together with an evaluation of the values.
}
\description{
Test how well-mixed and stationary the MCMC run is. A good value for the effective sample size ('ess', number of effective independent samples from the MCMC iterations) is >200 (>1000 indicates an excelling mixing). Besides the mixing, stationarity 'z' is also measured (the start of the run is compared with the end). A 'z' below 1.96 (1 standard deviation) indicates no drift, and if it is >2.58 (2 standard deviations) then the MCMC chain is likely drifting.
}
\details{
Generally Bacon will perform millions of MCMC iterations for each age-model run, although only a fraction
of these will be stored. In most cases the remaining MCMC iterations will be well mixed (ess, and also visually check that the upper left panel
of the fit of the iterations shows no strange features such as sudden systematic drops or rises).
}
\examples{
  \donttest{
    Bacon(ssize=100, coredir=tempfile()) # check the reported warnings
  }
}
