% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BchAddresses.R
\name{base58CheckEncode}
\alias{base58CheckEncode}
\title{Base 58 binary-to-text-encoding}
\usage{
base58CheckEncode(x)
}
\arguments{
\item{x}{\code{character}, string in hex format.}
}
\value{
\code{character}, the encoded string.
}
\description{
This is a modified binary-to-text encoding used
for encoding Bitcoin addresses, aka \emph{Base58Check}.
If this is applied to an extended private key with its trailing
check sum, then the result is the \emph{Wallet Import Format},
(WIF).
}
\references{
\url{https://en.bitcoin.it/wiki/Wallet_import_format},\cr
\url{https://en.bitcoin.it/wiki/Address},\cr
\url{https://en.bitcoin.it/wiki/Base58Check_encoding}
}
\seealso{
Other BchAdresses: 
\code{\link{BCHADR-class}},
\code{\link{BTCADR-class}},
\code{\link{PubHash2BchAdr}()},
\code{\link{PubKey2PubHash}()},
\code{\link{base58CheckDecode}()},
\code{\link{concatHex}()},
\code{\link{decodeHex}()},
\code{\link{hash160}()},
\code{\link{hash256}()},
\code{\link{validBchAdr}()},
\code{\link{validBtcAdr}()}
}
\author{
Bernhard Pfaff
}
\concept{BchAdresses}
