% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniprot_taxonomy.R
\name{rba_uniprot_taxonomy_name}
\alias{rba_uniprot_taxonomy_name}
\title{Search UniProt Taxonomic Names}
\usage{
rba_uniprot_taxonomy_name(
  name,
  field = "scientific",
  search_type = "equal_to",
  node_only = TRUE,
  page_size = 200,
  page_number = 1,
  ...
)
}
\arguments{
\item{name}{a name to to be used as search query.}

\item{field}{Specify the field that your supplied name should be searched.
It should be one of : "scientific" (default), "common" or "mnemonic".}

\item{search_type}{The logical relationship between your supplied search
query and the taxonomic name field. It should be one of "equal_to"
(default), "start_with", "end_with" or "contain".}

\item{node_only}{(logical) Retrieve only the node(s) information and exclude URL links
to parents, siblings and children nodes. default = TRUE}

\item{page_size}{(numeric) Your search results may be very long, thus
UniProt API will paginate the results, you may use this argument to control
the pagination. maximum value is 200.}

\item{page_number}{(numeric) Your search results may be very long, thus
UniProt API will paginate the results, you may use this argument to control
the pagination. maximum value is 200.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
a list containing taxonomic nodes that match your supplied inputs.
}
\description{
Using this function, you can search and retrieve taxonomic nodes using
  their names from
  \href{https://www.uniprot.org/help/taxonomy}{UniProt Taxonomy database}.
}
\section{Corresponding API Resources}{

 "GET https://ebi.ac.uk/proteins/api/name/\{name\}"
 \cr "GET https://ebi.ac.uk/proteins/api/name/\{name\}/node"
}

\examples{
\donttest{
rba_uniprot_taxonomy_name(name = "homo", field = "scientific",
    search_type = "start_with")
}
\donttest{
rba_uniprot_taxonomy_name(name = "adenovirus", field = "scientific",
    search_type = "contain", page_size = 200, page_number = 2)
}

}
\references{
\itemize{
  \item The UniProt Consortium , UniProt: the Universal Protein
  Knowledgebase in 2025, Nucleic Acids Research, 2024;, gkae1010,
  https://doi.org/10.1093/nar/gkae1010
  \item Andrew Nightingale, Ricardo Antunes, Emanuele Alpi, Borisas
  Bursteinas, Leonardo Gonzales, Wudong Liu, Jie Luo, Guoying Qi, Edd
  Turner, Maria Martin, The Proteins API: accessing key integrated protein
  and genome information, Nucleic Acids Research, Volume 45, Issue W1,
  3 July 2017, Pages W539–W544, https://doi.org/10.1093/nar/gkx237
  \item \href{https://www.ebi.ac.uk/proteins/api/doc/}{Proteins API
  Documentation}
  \item \href{https://www.uniprot.org/help/publications}{Citations note
  on UniProt website}
  }
}
\seealso{
Other "UniProt - Taxonomy": 
\code{\link{rba_uniprot_taxonomy}()},
\code{\link{rba_uniprot_taxonomy_lca}()},
\code{\link{rba_uniprot_taxonomy_lineage}()},
\code{\link{rba_uniprot_taxonomy_path}()},
\code{\link{rba_uniprot_taxonomy_relationship}()}
}
\concept{"UniProt - Taxonomy"}
