% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_relative_radius.R
\name{calc_relative_radius}
\alias{calc_relative_radius}
\title{Calculate relative radius}
\usage{
calc_relative_radius(angle, lens_coef)
}
\arguments{
\item{angle}{numeric vector. Zenith angles in degrees.}

\item{lens_coef}{numeric vector. Polynomial coefficients of the lens
projection function. See \code{\link[=lens]{lens()}}.}
}
\value{
Numeric vector of the same length as \code{angle}, constrained to [0, 1].
}
\description{
Convert zenith angles (degrees) to normalized radial distance using the lens
projection model.
}
\details{
This helper maps zenith angle(s) to a relative radius in [0, 1] given the
lens projection coefficients.
}
\examples{
calc_relative_radius(45, lens())
}
