% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ootb_bin.R
\name{ootb_bin}
\alias{ootb_bin}
\title{Out-of-the-box reliable binarized image}
\usage{
ootb_bin(caim, z, a, m, parallel = TRUE)
}
\arguments{
\item{caim}{numeric \link[terra:SpatRaster-class]{terra::SpatRaster} with three layers named
\code{"Red"}, \code{"Green"}, and \code{"Blue"}. Digital numbers should be linearly
related to radiance. See \code{\link[=read_caim_raw]{read_caim_raw()}} for details.}

\item{z}{\link[terra:SpatRaster-class]{terra::SpatRaster} generated with \code{\link[=zenith_image]{zenith_image()}}.}

\item{a}{\link[terra:SpatRaster-class]{terra::SpatRaster} generated with \code{\link[=azimuth_image]{azimuth_image()}}.}

\item{m}{logical \link[terra:SpatRaster-class]{terra::SpatRaster} with one layer. A binary mask with
\code{TRUE} for selected pixels.}

\item{parallel}{logical vector of length one. If \code{TRUE}, operations are
executed in parallel.}
}
\value{
Logical \link[terra:SpatRaster-class]{terra::SpatRaster} (\code{TRUE} for sky, \code{FALSE} for non-sky)
with the same number of rows and columns as \code{caim}.
}
\description{
Robust binarization without parameter tuning.
}
\details{
Runs a predefined pipeline that incrementally refines a binary sky mask by
combining gradient-based enhancement, local thresholding, polar segmentation,
and a spectral index sensitive to sunlit canopy.

\enumerate{
\item \emph{Enhancement.} Compute complementary gradients with
\code{\link[=complementary_gradients]{complementary_gradients()}} and build an enhancer that mixes the
strongest complementary response with the blue band:
\code{mem <- mean(normalize_minmax(max(yellow_blue, red_cyan)), normalize_minmax(Blue^(1/2.2)))}.
Gamma correction (see \code{\link[=invert_gamma_correction]{invert_gamma_correction()}}) is applied to the blue band to
reduce sky brightness variability.

\item \emph{Local thresholding.} Apply \code{\link[=apply_by_direction]{apply_by_direction()}} on \code{mem}
with \code{method = "thr_isodata"} to obtain an initial binary mask. Local
thresholding is required because background non-uniformity remains in the
enhanced image.

\item \emph{Cleanup.} Remove isolated pixels and apply a one-pixel binary
dilation. This compensates small artifacts produced by band misalignment
resulting from the radiometric-first policy of \code{\link[=read_caim_raw]{read_caim_raw()}}.

\item \emph{Polar quadtree segmentation.} Segment this preclassification of
sky and non-sky pixels with \code{\link[=polar_qtree]{polar_qtree()}} parameterized to yield circular
trapezoids never smaller than \eqn{3 \times 3} degrees and to minimize
segments with mixed classes.

\item \emph{Object-based image analysis.}
Keep segments that contain between 10 and 90 percent of sky pixels.
For each kept segment, estimate a local sky reference as the maximum blue
value, use it to normalize per segment
(\code{ratio <- Blue / sky_segment_max}), interpret the normalization as the degree
of membership to the sky class, and then defuzzify with a fixed threshold
\code{0.5}.

\item \emph{Blue–Red Index (BRI).} Compute
\deqn{\mathrm{BRI} = \frac{B - R}{B + R}}
where \eqn{B} and \eqn{R} are blue and red digital numbers. BRI decreases
on sunlit canopy because direct sunlight is warmer than diffuse skylight.
Use a scene-adaptive threshold given by the median BRI over the current
non-sky region to flip misclassified sky pixels to non-sky.

\item \emph{Zenith mask.} Apply the final zenith-angle gate (e.g.,
keep \eqn{\theta_z \le 88^\circ}).
}
}
\note{
This function is part of a paper under preparation.
}
\examples{
\dontrun{
caim <- read_caim()
r <- caim$Blue
z <- zenith_image(ncol(caim), lens())
a <- azimuth_image(z)
m <- !is.na(z)
bin <- ootb_bin(caim, z, a, m)
plot(bin)
}
}
