% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_bin.R
\name{read_bin}
\alias{read_bin}
\alias{write_bin}
\title{Write and read binarized images}
\usage{
read_bin(path)

write_bin(bin, path)
}
\arguments{
\item{path}{character vector of length one. File path to read or write. See
examples.}

\item{bin}{logical \link[terra:SpatRaster-class]{terra::SpatRaster} with a single layer.}
}
\value{
See \emph{Functions}
}
\description{
Wrapper functions around \code{\link[terra:rast]{terra::rast()}} to read and write binary masks.
}
\details{
\code{write_bin()} multiplies the input logical raster by 255 and writes the
result as a GeoTIFF (\code{GTiff}) with datatype \code{INT1U}. Both \code{write_bin()} and
\code{read_bin()} set the raster extent to \code{terra::ext(0, ncol(r), 0, nrow(r))}
and the CRS to EPSG:7589.
}
\section{Functions}{

\describe{
\item{\code{write_bin}}{Write a one-layer logical \link[terra:SpatRaster-class]{terra::SpatRaster}
to disk as a GeoTIFF (\code{GTiff}, \code{INT1U}). No return value.}
\item{\code{read_bin}}{Read a file with values \code{255} and/or \code{0}, such as the one
produced by \code{write_bin} (see \emph{Details}), and return a logical
\link[terra:SpatRaster-class]{terra::SpatRaster} (\code{TRUE} for \code{255}, \code{FALSE} for \code{0}).}
}
}

\examples{
\dontrun{
z <- zenith_image(1000, lens())
m <- !is.na(z)
my_file <- file.path(tempdir(), "mask.tif")
write_bin(m, my_file)
m_from_disk <- read_bin(my_file)
plot(m - m_from_disk)
}
}
\seealso{
\code{\link[=read_caim]{read_caim()}}, \code{\link[=write_caim]{write_caim()}}.
}
