% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mig_calculate_rc.R
\name{mig_calculate_rc}
\alias{mig_calculate_rc}
\title{Calculate Rogers-Castro migration age schedule}
\usage{
mig_calculate_rc(ages, pars)
}
\arguments{
\item{ages}{numeric. A vector of ages for migration rates to be calculated.}

\item{pars}{numeric. A named list of parameters. See below for details.}
}
\value{
A vector the same length as \code{ages}. Values represent migration rate for each age in \code{ages}.
}
\description{
Given a set of ages and parameters, calculate the migration age schedule based on the Rogers and Castro formula.
Choose between a 7, 9, 11 or 13 parameter model.
}
\details{
In the full 13 parameter model, the migration rate at age x, \eqn{m(x)} is defined as
\deqn{m(x) = a1*exp(-1*alpha1*x) + a2*exp(-1*alpha2*(x - mu2) - exp(-1*lambda2*(x - mu2))) + a3*exp(-1*alpha3*(x - 3) - exp(-1*lambda3*(x - mu3))) + a4*exp(lambda4*x) + c}

The first, second, third and fourth pieces of the equation represent pre-working age, working age, retirement and post-retirement age patterns, respectively.
Models with less parameters gradually remove terms at the older ages. Parameters in each family are:
\itemize{
\item pre-working age: a1, alpha1
\item working age: a2, alpha2, mu2, lambda2
\item retirement: a3, alpha3, mu3, lambda3
\item post retirement: a4, lambda4
}
For a specific family to be included, values for all parameters in that family must be specified.
}
\examples{
pars <- c(a1= 0.09, alpha1= 0.1, a2= 0.2,
alpha2= 0.1, mu2= 21, lambda2= 0.39, a3= 0.001,
alpha3= 1, mu3= 67, lambda3= 0.6, c= 0.01)
ages <- 0:75
mx <- mig_calculate_rc(ages = ages, pars = pars)

plot(ages, mx, type = 'l')

}
\references{
\insertRef{rogers1981model}{rcbayes}
}
