% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{generate_rsa_keys}
\alias{generate_rsa_keys}
\title{Generate RSA key pair and save to files}
\usage{
generate_rsa_keys(path, ..., password = NULL, which = "public", prefix = NULL)
}
\arguments{
\item{path}{A character string specifying the directory path where the key files in \code{.pem} format should be saved.}

\item{...}{Additional arguments passed to the \code{openssl::rsa_keygen()} function, such as key size.}

\item{password}{A character string specifying the password for the private key. If \code{NULL}, the private key will not be encrypted.}

\item{which}{A character string specifying which key to return. Can be either \code{"public"} or \code{"private"}. Default is \code{"public"}.}

\item{prefix}{A character string used as a prefix for the key file names. Defaults to \code{NULL}, which will result in no prefix.}
}
\value{
A character string representing the file path of the generated key (either public or private, based on the \code{which} argument).
}
\description{
This function generates an RSA key pair (public and private) and saves them to specified files.
}
\examples{
# Generate both public and private RSA keys and save them to the temp directory
path_to <- tempdir()
generate_rsa_keys(path = path_to, password = "securepassword")

}
