% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_parquet.R
\name{write_parquet}
\alias{write_parquet}
\title{Write Parquet file with optional encryption}
\usage{
write_parquet(data, path, ..., encryption_key = NULL)
}
\arguments{
\item{data}{A data frame or tibble to write to a Parquet file.}

\item{path}{The file path where the Parquet file will be written.}

\item{...}{Additional arguments passed to \code{arrow::write_parquet()} if no encryption key is provided.}

\item{encryption_key}{A list containing \code{aes_key} and \code{aes_iv}. If provided, the data will be encrypted using AES before writing to Parquet.}
}
\value{
None. The function writes the data to a Parquet file at the specified \code{path}.
}
\description{
This function writes a dataset to a Parquet file. If an encryption key is provided, the data will be encrypted before writing.
Otherwise, the function writes the data as a regular Parquet file without encryption.
}
\examples{

data <- mtcars
key <- "5bddd0ea4ab48ed5e33b1406180d68158aa255cf3f368bdd4744abc1a7909ead"
iv <- "7D3EF463F4CCD81B11B6EC3230327B2D"

temp_dir <- tempdir()

rcdf::write_parquet(
  data = data,
  path = file.path(temp_dir, "mtcars.parquet"),
  encryption_key = list(aes_key = key, aes_iv = iv)
)

unlink(file.path(temp_dir, "mtcars.parquet"), force = TRUE)

}
