% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family-dayarith.R, R/op-cdo-dayadd.R,
%   R/op-cdo-daydiv.R, R/op-cdo-daymul.R, R/op-cdo-daysub.R
\name{dayarith}
\alias{dayarith}
\alias{cdo_dayadd}
\alias{cdo_daydiv}
\alias{cdo_daymul}
\alias{cdo_daysub}
\title{Daily arithmetic}
\usage{
cdo_dayadd(ifile1, ifile2, ofile = NULL)

cdo_daydiv(ifile1, ifile2, ofile = NULL)

cdo_daymul(ifile1, ifile2, ofile = NULL)

cdo_daysub(ifile1, ifile2, ofile = NULL)
}
\arguments{
\item{ifile1, ifile2}{Strings with the path to the input files.}

\item{ofile}{String with the path to the output file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operators that don't return filenames return a character vector with the
string output.
}
\description{
This module performs simple arithmetic of a time series and one timestep with the same day, month and year. For each field in infile1 the corresponding field of the timestep in infile2 with the same day, month and year is used. The input files need to have the same structure with the same variables. Usually infile2 is generated by an operator of the module DAYSTAT.
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{dayadd  Add daily time series
        Adds a time series and a daily time series.
daysub  Subtract daily time series
        Subtracts a time series and a daily time series.
daymul  Multiply daily time series
        Multiplies a time series and a daily time series.
daydiv  Divide daily time series
        Divides a time series and a daily time series.
}\if{html}{\out{</div>}}
}
