% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recoding.R
\name{recode_vec}
\alias{recode_vec}
\title{Recode a vector}
\usage{
recode_vec(vec, to, from = NULL, .embed = TRUE, .bpr = TRUE)
}
\arguments{
\item{vec}{A vector}

\item{to}{A coding object to which the vector will be recoded}

\item{from}{A coding object that describes the current coding
of the vector. Defaults to the "rcoder.coding" attribute value, if
it exists, _or_ the "bpr.coding" value (from blueprintr). If neither
are found, `from` stays `NULL` and the function errors.}

\item{.embed}{If `TRUE`, `from` will be stored in the "rcoder.coding"
attribute}

\item{.bpr}{If `TRUE`, adds the _character_ representation of
the coding to the "bpr.coding" attribute. Used for interop with
blueprintr variable decorations}
}
\value{
The recoded vector
}
\description{
A simple interface to recoding a vector based on the coding linking
mechanism. If the vector has the "rcoder.coding" attribute, then
the coding object stored in that attribute will be used by default.
}
\examples{
# Using an explicit `from`
vec <- sample(1:3, 50, replace = TRUE)
cdng_old <- coding(code("Yes", 3), code("Maybe", 2), code("No", 1))
cdng_new <- coding(code("Yes", 2), code("Maybe", 1), code("No", 0))
recode_vec(vec, to = cdng_new, from = cdng_old)

# Using an implicit `from` with assign_coding()
vec <- sample(1:3, 50, replace = TRUE)
vec <- assign_coding(vec, cdng_old)
recode_vec(vec, cdng_new)
}
\seealso{
[assign_coding()]
}
