#' Sub-clinical ADHD behaviors and classroom functioning in schoolage children
#'
#' @description
#' Observations on children aged 9-11 in classroom settings, for a study on the
#' effects of sub-clinical hyperactive and inattentive behaviors on social and
#' academic functioning.
#'
#' @format A data frame with 686 observations on the following 4 variables:
#'
#' \describe{
#'   \item{sex}{(factor) 1=boy; 2=girl}
#'   \item{ethn}{(factor) 1=Colombian, 2=African American, 3=Hispanic American,
#'   5=European American}
#'   \item{hypb}{(numeric) Classroom hyperactive behaviour level.}
#'   \item{fcn}{(numreric) A measure of social and academic functioning.}
#'  }
#'
#' @references Brewis, A., Schmidt, K. L., & Meyer, M. (2000). ADHD‐Type
#' Behavior and Harmful Dysfunction in Childhood: A Cross‐Cultural Model.
#' American Anthropologist, 102(4), 823–828.
#' https://doi.org/10.1525/aa.2000.102.4.823
#'
#' @source `{DoubleCone}` package
#' Last retrieved from CRAN: 2024-10-12
#'
"doublecone"
