% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{get_config}
\alias{get_config}
\title{Get Configuration}
\usage{
get_config(file = "config.yml", config_name = "default")
}
\arguments{
\item{file}{Path to the YAML configuration file. For example, to load the sample
configuration provided in the package extdata directory, use:
`system.file("extdata", "config.yml", package = "rconf")`.}

\item{config_name}{The key in the configuration to extract (e.g., "default"). If the
key exists in the parsed configuration list, only that sub-list is returned.}
}
\value{
A list of configuration settings. When the configuration file contains multiple
  sections, and the section matching `config_name` is found, only that section is returned.
  Otherwise, the full configuration list is returned.
}
\description{
Reads a YAML configuration file (default "config.yml") and returns the
configuration stored under the specified key (default "default"). This function
merges the functionality of loading the file and parsing its contents into a list.
It uses UTF-8 encoding to read the file and then processes it with a minimal YAML parser.
}
\details{
If the parsed configuration list contains a component with the name specified by
`config_name`, only that component is returned. Otherwise, the entire configuration
list is returned.
}
\examples{
# Example: Load sample configuration from the extdata directory.
cfg <- get_config(system.file("extdata", "config.yml", package = "rconf"),
                  config_name = "default")
# Access specific configuration settings:
print(cfg$raw_data_dir)
print(cfg$processed_data_dir)

}
\author{
Yaoxiang Li
}
