% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmdata.R
\name{get_osm_railways}
\alias{get_osm_railways}
\title{Get OpenStreetMap railways}
\usage{
get_osm_railways(
  aoi,
  crs = NULL,
  railway_values = "rail",
  force_download = FALSE
)
}
\arguments{
\item{aoi}{Area of interest as sf object or bbox}

\item{crs}{A numeric vector of length one with the EPSG code of the CRS}

\item{railway_values}{A case-insensitive character vector with the railway
values to retrieve.}

\item{force_download}{Download data even if cached data is available}
}
\value{
An object of class \code{\link[sf:sfc]{sf::sfc_LINESTRING}}
}
\description{
Get OpenStreetMap railways
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bb <- get_osm_bb("Bucharest")
crs <- get_utm_zone(bb)
get_osm_railways(aoi = bb, crs = crs)
\dontshow{\}) # examplesIf}
}
