% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stdyInfo.R
\name{ddi_stdyInfo}
\alias{ddi_stdyInfo}
\alias{ddi_abstract}
\alias{ddi_studyBudget}
\title{stdyInfo and its child nodes}
\usage{
ddi_stdyInfo(...)

ddi_abstract(...)

ddi_studyBudget(...)
}
\arguments{
\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object.
}
\description{
stdyInfo is the study scope. It contains information about the data
collection's scope across several dimensions, including substantive content,
geography, and time. More information on these elements, especially their
allowed attributes, can be found in the references.
}
\details{
\emph{Parent nodes}

\code{stdyInfo} is contained in \code{stdyDscr}.

\emph{stdyInfo specific child nodes}
\itemize{
\item \code{ddi_abstract()} is an unformatted summary describing the purpose, nature,
and scope of the data collection, special characteristics of its contents,
major subject areas covered, and what questions the PIs attempted to answer
when they conducted the study. A listing of major variables in the study is
important here. In cases where a codebook contains more than one abstract
(for example, one might be supplied by the data producer and another
prepared by the data archive where the data are deposited), the "source"
and "date" attributes may be used to distinguish the abstract versions. Maps
to Dublin Core Description element. Inclusion of this element in the
codebook is recommended. The "date" attribute should follow ISO convention
of YYYY-MM-DD.
\item \code{ddi_studyBudget()}is used to describe the budget of the project in as
much detail as needed.
}
}
\section{Shared and complex child nodes}{

\itemize{
\item \code{\link[=ddi_exPostEvaluation]{ddi_exPostEvaluation()}}
\item \code{\link[=ddi_notes]{ddi_notes()}}
\item \code{\link[=ddi_qualityStatement]{ddi_qualityStatement()}}
\item \code{\link[=ddi_subject]{ddi_subject()}}
\item \code{\link[=ddi_sumDscr]{ddi_sumDscr()}}
}
}

\examples{
ddi_stdyInfo()

# Functions that need to be wrapped in ddi_stdyInfo()

ddi_abstract(date = "1999-01-28",
             contentType = "abstract",
             "Data on labor force activity for the week prior to the survey 
             are supplied in this collection. Information is available on the 
             employment status, occupation, and industry of persons 15 years 
             old and over. Demographic variables such as age, sex, race, marital 
             status, veteran status, household relationship, educational 
             background, and Hispanic origin are included. In addition to 
             providing these core data, the May survey also contains a 
             supplement on work schedules for all applicable persons aged 
             15 years and older who were employed at the time of the survey. 
             This supplement focuses on shift work, flexible hours, and work 
             at home for both main and second jobs.")

ddi_studyBudget("The budget for the study covers a 5 year award period 
                distributed between direct and indirect costs including: 
                Staff, ...")

}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/stdyInfo.html}{stdyInfo documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/abstract.html}{abstract documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/studyBudget.html}{studyBudget documentation}
}
