% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdi_functions.R
\name{rdi}
\alias{rdi}
\title{Calculate RDI dissimilarity matrix}
\usage{
rdi(genes, seqAnnot, params = NULL, ...)
}
\arguments{
\item{genes}{vector (or matrix) containing the gene calls for each sequence.
If genes is a matrix, counts will be calculated for each 
column of 'genes', and the resulting count matrices will be
concatenated.}

\item{seqAnnot}{matrix containing repertoire annotations. Must be same length
as 'genes'.}

\item{params}{list; contains parameters to pass to child functions.
Should contain \code{countParams} and \code{distParams} lists,
which contain parameters for \link{calcVDJcounts} and
\link{calcRDI}, respectively. See Details.}

\item{...}{other parameters to pass to \link{calcVDJcounts} and 
\link{calcRDI}.}
}
\value{
Dissimilarity structure, as calculated by dist. In addition to the standard
attributes returned by dist, two additional attributes are defined as follows:
\tabular{rl}{
  \emph{nseq}  \tab integer, the number of sequences used after subsampling  
                              the repertoires\cr
  \emph{ngenes}  \tab integers, the number of genes in each column of "genes" 
                                that were included in at least one repertoire.
}
}
\description{
Wrapper function for calculating RDIs
}
\details{
This function is a wrapper for the two core functions of RDI, 
\link{calcVDJcounts} and \link{calcRDI}. To control the function of 
both \code{calcVDJcounts} and \code{calcRDI}, additional parameters can be specified
either directly in the RDI function call, or parameters for the individual functions 
can be wrapped up into lists of parameters and passed into the \code{params} parameter.
\code{params} should be a list containing at least one of two parameter lists:
\code{countParams} and \code{distParams}, which  
will be passed to \code{calcVDJcounts} and \code{calcRDI}, respectively. An example
analysis is included below.
}
\examples{

#create genes
genes = sample(letters, 10000, replace=TRUE)

#create sequence annotations
seqAnnot = data.frame(donor = sample(1:4, 10000, replace=TRUE),
                      visit = sample(c("V1","V2","V3"), 10000, replace=TRUE),
                      cellType = sample(c("B","T"), 10000, replace=TRUE)
                     )
                     
#parameters
params = list(
  countParams = list(
    select = list(
      visit = c("V1","V3"),
      cellType = "B"
    ),
    combine = list(
      visit = "V[13]"
    ),
    simplifyNames = FALSE
  ),
  distParams = list(
    constScale=FALSE
  )
)

##calculate RDI
d = rdi(genes, seqAnnot, params)

##plot using hierarchical clustering
plot(hclust(d))

}
