% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tags.R
\name{guardian_tags}
\alias{guardian_tags}
\title{Search Guardian Tags}
\usage{
guardian_tags(api_key, query, section = NULL, reference = NULL,
  reference_type = NULL, page = NULL, page_size = 50, ...)
}
\arguments{
\item{api_key}{A key to the Guardian API, which can be obtained
\href{http://open-platform.theguardian.com/access/}{here}.}

\item{query}{Your search query. This can contain operators (\code{sausage AND mash}) or
phrases (\code{"sausage & mash"}); by default, searches work as an OR, looking for
the presence of any one individual word in the query.}

\item{section}{the section, or sections, of \emph{The Guardian} that you want to limit the search to. Multiple
sections may be concatenated together using boolean operators; see \code{\link{guardian_and}} and \code{\link{guardian_and}}.}

\item{reference}{the references to limit the search to; only tags that include those references (and meet other
conditions) will be returned. Also accepts boolean operators.}

\item{reference_type}{the type of reference (such as \code{isbn}). Also accepts boolean operators.}

\item{page}{a particular page of results to return. Useful when returning multiple sets of data with the same query;
you can repeat the query, incrementing the value in \code{page}.}

\item{page_size}{the maximum number of items to return; anywhere between 1 and 50. Set to 50 by default.}

\item{...}{further arguments to pass to httr's \code{GET}.}
}
\description{
\code{guardian_tags} lets you directly search
The Guardian for their tags - metadata used to classify content.
}
\examples{
\dontrun{
# Simple example
results <- guardian_tags("test", "green")
}
}
\seealso{
\code{\link{guardian_content}}.
}

