% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/API_rdtLite.R
\name{prov.json}
\alias{prov.json}
\alias{prov.dir}
\alias{prov.visualize}
\alias{prov.summarize}
\title{Provenance Access Functions}
\usage{
prov.json()

prov.dir()

prov.visualize()

prov.summarize(
  save = FALSE,
  create.zip = FALSE,
  details = FALSE,
  check = TRUE,
  console = TRUE,
  notes = TRUE
)
}
\arguments{
\item{save}{if true saves the summary to the file prov-summary.txt in the 
provenance directory}

\item{create.zip}{if true all of the provenance data will be packaged up
into a zip file stored in the current working directory.}

\item{details}{if true, a more detailed summary is provided}

\item{check}{if true, the user's file system is checked to see if input 
files, output files, and scripts (in their original locations) are unchanged, 
changed, or missing.}

\item{console}{if true, the summary is displayed in the console}

\item{notes}{if true, notes are included to explain how to interpret the summary}
}
\value{
prov.json returns the current provenance graph as a prov-json
string

prov.dir returns the current provenance directory.

prov.visualize loads and displays the current provenance graph
in DDG Explorer. The prov.visualize function does not return a value.
}
\description{
prov.json returns the current provenance graph as a prov-json string.

prov.dir returns the current provenance directory.

prov.visualize displays the current provenance as a graph.

prov.summarize outputs a text summary to the R console
}
\details{
rdtLite collects provenance as a script executes.  Once collected,
prov.json can be called to access the provenance as a JSON string.  
This is useful for applications that operate on the provenance.  The
JSON is consistent with the PROV-JSON standard.

One such application is a graphic visualizer built into rdt.
To view the provenance graphically, call prov.visualize.  In the provenance
graph, the nodes are data values and operations, with edges connecting 
them to show data and control flow dependencies.  The visualizer also
allows the user to view intermediate values of variables, and to graphically
view the lineage of how a value was computed, or to look at how a value 
is used moving forward in the computation. The user can also search for specific
data or operation nodes, files, or error messages in the provenance.

Creating a zip file depends on a zip executable being on the search path.
By default, it looks for a program named zip.  To use a program with 
a different name, set the value of the R_ZIPCMD environment variable.  This
code has been tested with Unix zip and with 7-zip on Windows.
}
\examples{
\donttest{prov.init()}
\donttest{a <- 1}
\donttest{b <- 2}
\donttest{ab <- a + b}
\donttest{prov.quit()}
\donttest{str <- prov.json()}
\donttest{pdir <- prov.dir()}
}
\references{
PROV-JSON standard: \url{https://www.w3.org/Submission/2013/SUBM-prov-json-20130424/}

PROV-JSON output produced by rdtLite: \url{https://github.com/End-to-end-provenance/ExtendedProvJson/blob/master/JSON-format.md}

Applications that use the provenance:  \url{https://github.com/End-to-end-provenance/End-to-end-provenance.github.io/blob/master/RTools.md}
}
\seealso{
\code{\link{prov.init}} and \code{\link{prov.run}} for functions to collect provenance
}
