% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_sinks.R
\name{fill_sinks}
\alias{fill_sinks}
\title{Fill sinks in a digital elevation model (DEM)}
\usage{
fill_sinks(dem, out_dem, out_fd, out_sinks, overwrite = FALSE, ...)
}
\arguments{
\item{dem}{The name of a DEM in the current GRASS mapset.}

\item{out_dem}{Name of the output DEM, which is a hydrologically corrected (sink-filled) DEM.}

\item{out_fd}{Name of the output flow direction map for the sink-filled DEM.}

\item{out_sinks}{Optional argument giving the name of the output sinks raster. Leave this missing to skip the output.}

\item{overwrite}{A logical indicating whether the output should be allowed to overwrite existing files. Defaults to \code{FALSE}.}

\item{...}{Optional additional parameters to \code{r.fill.dir}.}
}
\value{
Nothing. A file with the name \code{out} will be created in the current GRASS mapset.
}
\description{
Remove sinks in a DEM (see the 'Details' section)
}
\details{
A sink is a depression in a DEM. Water flows into these depressions but does not flow out of them. These depressions, although often real features of landscapes, are problematic for flow direction and accumulation algorithms. Therefore, it is common practice to remove these depressions.
}
\examples{
# Will only run if GRASS is running
if(check_running()){
# Retrieve paths to data sets
dem <- system.file("extdata", "dem.tif", package = "rdwplus")
lus <- system.file("extdata", "landuse.tif", package = "rdwplus")
sts <- system.file("extdata", "site.shp", package = "rdwplus")
stm <- system.file("extdata", "streams.shp", package = "rdwplus")

# Set environment
set_envir(dem)

# Get other data sets (stream layer, sites, land use, etc.)
raster_to_mapset(lus)
vector_to_mapset(c(stm, sts))

# Reclassify streams
out_stream <- paste0(tempdir(), "/streams.tif")
rasterise_stream("streams", out_stream, TRUE)
reclassify_streams("streams.tif", "streams01.tif", overwrite = TRUE)

# Burn in the streams to the DEM
burn_in("dem.tif", "streams01.tif", "burndem.tif", overwrite = TRUE)

# Fill dem
fill_sinks("burndem.tif", "filldem.tif", "fd1.tif", "sinks.tif", overwrite = TRUE)
}
}
