% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highlight_min.R
\name{highlight_min}
\alias{highlight_min}
\title{Highlights the minimum value in a column}
\usage{
highlight_min(data, font_color = "red", highlighter = NULL)
}
\arguments{
\item{data}{Dataset containing at least one numeric column.}

\item{font_color}{color to assign to minimum value in a column.
Default color is red.}

\item{highlighter}{color to assign the background of a cell containing minimum value in a column.}
}
\value{
a function that applies a color
    to the minimum value in a column of numeric values.
}
\description{
The `highlight_min()` function assigns a font color and/or background color to the minimum value in a column.
    It should be placed within the style argument in reactable::colDef.
}
\examples{
data <- MASS::road[11:17, ]

## By default, the minimum value is bold with a red font color
reactable(data,
defaultColDef = colDef(
    style = highlight_min(data)))

## Assign a different font color
reactable(data,
defaultColDef = colDef(
    style = highlight_min(data,
    font_color = "green")))

## Highlight the background of the cell for the minimum value in each column
reactable(data,
defaultColDef = colDef(
    style = highlight_min(data,
    highlighter = "yellow")))

}
