% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{sandstone}
\alias{sandstone}
\title{Theme sandstone}
\usage{
sandstone(
  font_size = 15,
  font_color = "#3e3f3a",
  header_font_size = 16,
  header_font_color = "#7c7a78",
  cell_padding = 6,
  centered = FALSE
)
}
\arguments{
\item{font_size}{Numeric value representing the size of the font within the table (in px).
Default is 15.}

\item{font_color}{Color of the font for the text within the table and the group headers.
Default is #3e3f3a.}

\item{header_font_size}{Numeric value representing the size of the font within the table (in px).
Default is 16.}

\item{header_font_color}{Color of the font for the header text.
Default is #7c7a78.}

\item{cell_padding}{Numeric value representing the padding size between cells (in px).
Default is 6.}

\item{centered}{Logical: vertically center the contents of the table.
Default is FALSE.}
}
\value{
an object of class theme that is applied to a reactable table.
}
\description{
Bootstrap-inspired sandstone theme
}
\examples{
data <- iris[10:29, ]

## Standard sandstone theme
reactable(data,
          theme = sandstone())

## Additional options applied
reactable(data,
          theme = sandstone(font_size = 12, font_color = "grey", cell_padding = 3))

}
