% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt3x_info.R
\name{parse_gt3x_info}
\alias{parse_gt3x_info}
\alias{extract_gt3x_info}
\title{Parse GT3X info.txt file}
\usage{
parse_gt3x_info(path, tz = "GMT")

extract_gt3x_info(path, tz = "GMT")
}
\arguments{
\item{path}{Path to a .gt3x file or an unzipped gt3x directory}

\item{tz}{timezone, passed to \code{\link{ticks2datetime}}}
}
\description{
Parse GT3X info.txt file
}
\note{
The input for \code{parse_gt3x_info} is a \code{gt3x} file, but
the \code{path} for \code{extract_gt3x_info} is the \code{info.txt} file,
which can also pass in a connection
}
\examples{
gt3xfile <-
  system.file(
    "extdata", "TAS1H30182785_2019-09-17.gt3x",
    package = "read.gt3x")
parse_gt3x_info(gt3xfile)

\dontrun{
gt3xfile <- gt3x_datapath(1)
parse_gt3x_info(gt3xfile)
}

}
\seealso{
Other gt3x-parsers: 
\code{\link{as.data.frame.activity}()},
\code{\link{print.gt3x_info}()},
\code{\link{read.gt3x}()}
}
\concept{gt3x-parsers}
