% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SBC.R
\name{sd_data_generator_fun}
\alias{sd_data_generator_fun}
\title{Function factory for SBC}
\usage{
sd_data_generator_fun(
  filepath,
  estimated_params,
  meas_mdl,
  start_time = NULL,
  stop_time = NULL,
  timestep = NULL,
  integ_method = "euler"
)
}
\arguments{
\item{filepath}{A string that indicates a path to a file with extension .stmx
or .xmile. Vensim files (.mdl) are not xmile files. They must be exported
from Vensim with extension .xmile}

\item{estimated_params}{A list of lists. Each sublist describes each
parameter that will be estimated in the inference stage. To construct this
description, the user can avail of the function `sd_prior`.}

\item{meas_mdl}{A list of strings. Each string corresponds to a sampling
statement written in Stan language.}

\item{start_time}{A number indicating the time at which the simulation begins.}

\item{stop_time}{A number indicating the time at which the simulation ends.}

\item{timestep}{A number indicating the time interval for the simulation.
Also known as \code{dt}.}

\item{integ_method}{A string indicating the integration method. It can be
either "euler" or "rk4"}
}
\value{
A function.
}
\description{
Function factory for SBC
}
\examples{
  filepath <- system.file("models/", "SEIR.stmx", package = "readsdr")
  meas_mdl <- list("y ~ poisson(net_flow(C))")
  estimated_params <- list(
    sd_prior("par_beta", "lognormal", c(0, 1)),
    sd_prior("par_rho", "beta", c(2, 2)),
    sd_prior("I0", "lognormal", c(0, 1), "init"))
  sd_data_generator_fun(filepath, estimated_params, meas_mdl)
}
