#include "cpp11.hpp"
using namespace cpp11;
#include <cstdlib>   // for std::strtod

// Generated by asking ChatGPT to translate an R-based, no-AI version
// into cpp11. I reviewed the generated code, clarified the meaning of some
// lines with AI, and made code comment notes.

// early declaration to satisfy RStudio warning
list cpp_parse_praat_numbers(strings x);

[[cpp11::register]]
list cpp_tg_scan_tokens(std::string src) {
  // final space required
  if (src.empty() || src.back() != 0x20) src.push_back(0x20);

  const size_t nbytes = src.size();

  writable::strings tokens;
  writable::logicals tokens_is_string;

  bool in_comment = false;
  bool in_string  = false;
  // are we in a "" sequence (escaped quotes)?
  bool esc_next   = false;

  bool   have_token = false;
  size_t tok_start_byte = 0;

  size_t prev_char_byte = 0;
  size_t curr_char_byte = 0;

  // Is this a UTF-8 continuation byte? (10xxxxxx)
  auto is_cont = [](unsigned char b)->bool {
    // Are the first two bits 10?
    return (b & 0xC0) == 0x80;
  };
  // Is this an ASCII whitespace?
  auto is_ws   = [](unsigned char b)->bool {
    // space, tab, CR, LF
    return b == 0x20 || b == 0x09 || b == 0x0D || b == 0x0A;
  };

  for (size_t i = 0; i < nbytes; ++i) {
    // char might be signed on some systems so make sure we have
    // a simple unsigned char
    unsigned char b = static_cast<unsigned char>(src[i]);
    if (is_cont(b)) continue;

    prev_char_byte = curr_char_byte;
    curr_char_byte = i;

    if (in_comment) {
      if (b == 0x0A) in_comment = false;
      continue;
    }
    if (!in_string && b == 0x21) { // '!'
      in_comment = true;
      continue;
    }
    if (esc_next) { esc_next = false; continue; }

    if (!in_string && is_ws(b)) {
      if (have_token) {
        size_t start = tok_start_byte;
        size_t end   = (curr_char_byte == 0 ? 0 : prev_char_byte);
        size_t len   = (end >= start) ? (end - start + 1) : 0;
        if (len > 0) {
          // do we have a string (start and end with ")
          bool q = (static_cast<unsigned char>(src[start]) == 0x22) &&
            (static_cast<unsigned char>(src[end])   == 0x22);
          tokens.push_back(src.substr(start, len));
          tokens_is_string.push_back(q);
        }
        have_token = false;
      }
      continue;
    }

    if (b == 0x22) { // '"'
      // peek ahead to see if we have a double "" escapement
      size_t j = i + 1;
      // We need the next character, not just the next byte, so we skip
      // continuation characters.
      while (j < nbytes && is_cont(static_cast<unsigned char>(src[j]))) ++j;
      // Use `0x00` dummy character if we are at then end of the string
      unsigned char nextb = (j < nbytes) ? static_cast<unsigned char>(src[j]) : 0x00;

      if (in_string && nextb == 0x22) {
        esc_next = true;    // consume next '"' once
      } else {
        in_string = !in_string;
      }
    }

    if (!have_token) {
      have_token = true;
      tok_start_byte = curr_char_byte;
    }
  }

  list number_data = cpp_parse_praat_numbers(tokens);
  writable::list out(4);
  out[0] = tokens;                         // strings
  out[1] = tokens_is_string;               // writable::logicals
  out[2] = number_data[0];                 // prefix_len (integers)
  out[3] = number_data[1];                 // value (doubles)
  out.attr("names") = writable::strings({"tokens", "is_string", "num_prefix", "num_value"});
  return out;
}


[[cpp11::register]]
list cpp_parse_praat_numbers(strings x) {
  R_xlen_t n = x.size();
  writable::doubles out_len(n);  // store prefix length
  writable::doubles out_val(n);  // store parsed value (for testing)

  for (R_xlen_t i = 0; i < n; i++) {
    if (x[i] == NA_STRING) {
      out_len[i] = NA_REAL;
      out_val[i] = NA_REAL;
      continue;
    }

    const char* str = Rf_translateCharUTF8(x[i]);

    // Reject leading '.' per Praat rule (".4" invalid)
    if (str[0] == '.' ) {
      out_len[i] = 0;
      out_val[i] = NA_REAL;
      continue;
    }

    // Allow optional sign
    const char* p = str;
    if (*p == '+' || *p == '-') ++p;
    if (!(*p >= '0' && *p <= '9')) {
      out_len[i] = 0;
      out_val[i] = NA_REAL;
      continue;
    }

    char* endptr = nullptr;
    double val = std::strtod(str, &endptr);

    if (endptr == str) {
      out_len[i] = 0;
      out_val[i] = NA_REAL;
    } else {
      out_len[i] = static_cast<double>(endptr - str);
      out_val[i] = val;
    }
  }

  // Return as a data.frame-like list
  writable::list res;
  res.push_back(out_len);
  res.push_back(out_val);
  res.attr("names") = writable::strings({"prefix_len", "value"});
  return res;
}
