% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attenuation_of_sound_by_water.R
\name{attenuation_of_sound_by_water}
\alias{attenuation_of_sound_by_water}
\title{Compute attenuation of sound in water given frequency, temperature, and salinity}
\usage{
attenuation_of_sound_by_water(freq, temp, sal)
}
\arguments{
\item{freq}{frequency of sound (Hz)}

\item{temp}{Water temperature (degrees C)}

\item{sal}{Salinity (PSU)}
}
\value{
attenuation of sound in water (dB/m), divide by 20*log10(exp(1)) to convert to Nepers/m
}
\description{
Computes attenuation of sound in water per Ainslie and McColm (1998)
}
\examples{
InputData <- realTimeloads::ExampleData
freq <- InputData$ADCP$Accoustic_Frequency_kHz*1000
cond <-InputData$Sonde$Conductivity_uS_per_cm
temp <- InputData$Sonde$Water_Temperature_degC
dbar <- InputData$Sonde$Pressure_dbar
sal <- ctd2sal(cond,temp,dbar)
aw <- attenuation_of_sound_by_water(freq,temp,sal) # dB/m
awNp <- attenuation_of_sound_by_water(freq,temp,sal)/(20*log10(exp(1))) # Np/m
}
\references{
Ainslie, M. A., & McColm, J. G. (1998). A simplified formula for viscous and chemical absorption in sea water. The Journal of the Acoustical Society of America, 103(3), 1671-1672.

Author modified Matlab code from David Schoellhamer
}
\author{
Daniel Livsey (2023) ORCID: 0000-0002-2028-6128
}
