% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_data.R
\name{import_data}
\alias{import_data}
\title{Load data from comma-delimited .txt files to list to be used in function hADCPLoads()}
\usage{
import_data(data_folder)
}
\arguments{
\item{data_folder}{file path to folder containing .txt csv files with format that matches files in extdata package folder}
}
\value{
list with data frames used in package code, see ?ExampleData for list format
}
\description{
Imports csv files to R, file names, variable names (and units) in csv text files must match variable names used in ExampleData.rda
}
\section{Warning}{

Synthetic data used in ExampleData only has backscatter for one beam ("ADCP_Echo_Intensity.txt"), for user data, one should have backscatter for two beams with following names: "ADCP_Echo_Intensity_Beam_1.txt" and "ADCP_Echo_Intensity_Beam_2.txt"

Package arguments require variable names and units to match the names and variable units provided (see ?ExampleData, or .txt files in extdata folder)

Suggest saving all csv files in .txt format to ensure time format is not changed when editing/saving csv in Excel
}

\examples{
InputData <- import_data() # loads text files provided in package folder "extdata"
}
\references{
Livsey, D.N. (in review). National Industry Guidelines for hydrometric monitoring–Part 12: Application of acoustic Doppler velocity meters to measure suspended-sediment load. Bureau of Meteorology. Melbourne, Australia.
}
\seealso{
\code{\link{hADCPLoads}} Process acoustic backscatter from hADCP and compute load using InputData from import_Data()
}
\author{
Daniel Livsey (2023) ORCID: 0000-0002-2028-6128
}
