% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat_fn.R
\name{cat_fn}
\alias{cat_fn}
\title{Compares observed and expected distribution of a categorical (binomial) variable}
\usage{
cat_fn(
  df = cat_data,
  x_title = "",
  prefix = "",
  del.disparate = "yes",
  title = "",
  verbose = TRUE
)
}
\arguments{
\item{df}{data frame generated from load_clean function}

\item{x_title}{name of the variable for use on the x-axis}

\item{prefix}{letter for variable columns in data frame}

\item{del.disparate}{if yes, data in which the absolute difference between group sizes is >20\% are deleted}

\item{title}{title name for plots (optional)}

\item{verbose}{TRUE or FALSE indicates whether to print plot}
}
\value{
list containing 4 objects as described

\itemize{
\item cat_graph = plot of observed to expected numbers and differences between groups, top panels are the absolute numbers, bottom panels are the differences between trial arms in two arm studies
\item cat_data_abs = data frame of data for absolute numbers
\item cat_data_df = data frame of data for difference between groups in two arm studies
\item cat_all_graphs = list containing
\itemize{
\item abs = plot for absolute numbers only
\item df = plot for difference between groups in two arm studies only
\item individual_graphs list of 4 individual plots making up composite figures
}
}
}
\description{
Creates plots of observed to expected numbers and ratios for the specified binomial variable \cr
}
\details{
An example is for trial withdrawls in Bolland 2021\cr
Bolland MJ, Gamble GD, Avenell A, Cooper DJ, Grey A. Participant withdrawals were unusually distributed in randomized trials with integrity concerns: a statistical investigation. J Clin Epidemiol 2021;131:22-29.

Returns a list containing 4 objects and (if verbose = TRUE) prints the plot cat_graph
}
\examples{
# load example data
cat_data <- load_clean(import= "no", file.cat = "SI_cat", cat= "yes",
format.cat = "wide", cat.names = c("n", "w"))$cat_data

\donttest{
# run function (takes only a few seconds)
cat_fn(x_title= "withdrawals", prefix="w", del.disparate = "yes")$cat_graph


# to import an excel spreadsheet (modify using local path,
# file and sheet name, range, and format):

# get path for example files
path <- system.file("extdata", "reappraised_examples.xlsx", package = "reappraised",
                    mustWork = TRUE)
# delete file name from path
path <- sub("/[^/]+$", "", path)

# load data
cat_data <- load_clean(import= "yes", cat = "yes", dir = path,
    file.name.cat = "reappraised_examples.xlsx", sheet.name.cat = "SI_cat",
    range.name.cat = "A:G", cat.names = c("n", "w"), format.cat = "wide")$cat_data}

}
