% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleaning_functions.R
\name{mrg_cen_cols}
\alias{mrg_cen_cols}
\title{Merge together observed concentrations and detection limits}
\usage{
mrg_cen_cols(qual, result, limit, nd = c("<", "nd", "ND"))
}
\arguments{
\item{qual}{A character vector containing non-detect indicator strings, e.g., "<" or "ND". The strings used to indicate censored status can be edited in the "nd" argument.}

\item{result}{A numeric vector of concentration measurements.}

\item{limit}{A numeric vecotr of method detection limit/reporting limit values.}

\item{nd}{A list indicating all the censoring flags included in the dataset. Defaults to "<", "nd", and "ND".}
}
\value{
A numeric vector.
}
\description{
Merge a results column with a detection limits column by overwriting the censored results values with the corresponding detection limit.
}
\examples{
result <- runif(5, 1, 10)
cen_result <- sample(c("<", ""), length(result), replace = TRUE)
method_limit <- rep(0.1, length(result))
result <- mrg_cen_cols(cen_result, result, method_limit)
print(data.frame(cen_result, result, stringsAsFactors = FALSE))
}
