% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PIT_local.R
\name{PIT_local}
\alias{PIT_local}
\title{Obtain local PIT-values from a model}
\usage{
PIT_local(
  xcal,
  ycal,
  yhat,
  mse,
  clusters = 6,
  p_neighbours = 0.2,
  PIT = PIT_global
)
}
\arguments{
\item{xcal}{Numeric matrix or data frame of features/covariates (x-values) from the calibration dataset.}

\item{ycal}{Numeric vector representing the true observations (y-values) of the response variable from the calibration dataset.}

\item{yhat}{Numeric vector of predicted response (y-hat-values) from the calibration dataset.}

\item{mse}{Mean Squared Error calculated from the calibration dataset.}

\item{clusters}{Integer specifying the number of partitions to create for local calibration using the k-means method. Default is set to 6.}

\item{p_neighbours}{Proportion of xcal used to localize neighbors in the KNN method. Default is 0.2.}

\item{PIT}{Function used to calculate the PIT-values. Default is set to \code{PIT_global()} from this package, that assumes a Gaussian distribution.}
}
\value{
A tibble with five columns containing unique names for each partition ("part"), "y_cal" (true observations),
"y_hat" (predicted values), "pit" (PIT-values), and "n" (number of neighbors) for each partition.
}
\description{
This function calculates local Probability Integral Transform (PIT) values using localized subregions of the covariate space from the calibration set.
The output will be used for visualization of calibration quality using the \code{gg_CD_local()} and \code{gg_PIT_local()}function.
}
\details{
It calculates local Probability Integral Transform (PIT) values using localized subregions of the covariate space from the calibration set.
The centroids of such regions are derived from a k-means clustering method (from the \code{stats} package). The local areas around these centroids
are defined through an approximate k-nearest neighbors method from the \code{RANN} package.
Then, for this subregion, the PIT-values are calculated using the \code{PIT} function provided by the user. At the moment this function is tested to
work with the \code{PIT_global()} function from this package, which assumes a Gaussian distribution. Eventually, it can be used with other distributions.
}
\examples{

n <- 10000
split <- 0.8

mu <- function(x1){
10 + 5*x1^2
}

sigma_v <- function(x1){
 30*x1
}

x <- runif(n, 1, 10)
y <- rnorm(n, mu(x), sigma_v(x))

x_train <- x[1:(n*split)]
y_train <- y[1:(n*split)]

x_cal <- x[(n*split+1):n]
y_cal <- y[(n*split+1):n]

model <- lm(y_train ~ x_train)

y_hat <- predict(model, newdata=data.frame(x_train=x_cal))

MSE_cal <- mean((y_hat - y_cal)^2)

PIT_local(xcal = x_cal, ycal=y_cal, yhat=y_hat, mse=MSE_cal)

}
