% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redbook_data.R
\docType{data}
\name{redbook_tab}
\alias{redbook_tab}
\title{Species Names Listed in The Red Book of Endemic Plants of Peru}
\format{
A tibble with the following columns:
\describe{
\item{redbook_id}{The fixed species ID of the input taxon in The Red Book of Endemic Plants of Peru.}
\item{redbook_name}{A character vector. The species name as listed in The Red Book of Endemic Plants of Peru.}
\item{input_genus}{A character vector. The input genus of the corresponding species name listed.}
\item{input_epitheton}{A character vector. The specific epithet of the corresponding species name listed.}
\item{rank}{A character vector. The taxonomic rank (e.g., "species", "subspecies", "variety") of the corresponding species name listed.}
\item{input_subspecies_epitheton}{A character vector. The infraspecific epithet of the corresponding species name listed, if applicable.}
\item{accepted_name}{A character vector. The accepted plant taxa names according to the World Checklist of Vascular Plants (WCVP).}
\item{accepted_family}{A character vector. The corresponding family name of the accepted name.}
\item{accepted_name_author}{A character vector. The author of the accepted name.}
\item{accepted_name_rank}{A character vector. The rank of the accepted name (e.g., species, subspecies).}
\item{tag_subsp_wcvp}{A character vector. A tag indicating if the subspecies is recognized in the WCVP.}
\item{genus_ephitethon_wcvp}{A character vector. The genus part of the name according to the WCVP.}
\item{species_ephitethon_wcvp}{A character vector. The specific epithet part of the name according to the WCVP.}
\item{subspecies_ephitethon_wcvp}{A character vector. The infraspecific epithet part of the name according to the WCVP, if applicable.}
}
}
\usage{
redbook_tab
}
\description{
The \code{redbook_tab} contains records for all species listed in The Red Book of Endemic Plants of Peru.
}
\examples{

data("redbook_tab")
head(redbook_tab)

}
\references{
León, Blanca, et.al. 2006. “The Red Book of Endemic Plants of Peru”. Revista Peruana De Biología 13 (2): 9s-22s. https://doi.org/10.15381/rpb.v13i2.1782.
}
\keyword{datasets}
