% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_threats.R
\name{rl_threats}
\alias{rl_threats}
\title{IUCN Red List threat categories}
\usage{
rl_threats(
  code = NULL,
  year_published = NULL,
  latest = NULL,
  possibly_extinct = NULL,
  possibly_extinct_in_the_wild = NULL,
  scope_code = NULL,
  page = 1
)
}
\arguments{
\item{code}{Character. One or more threat codes (e.g., "1").
Use \code{\link[=rl_threats]{rl_threats()}} to list available threat categories.}

\item{year_published}{Optional. Single or numeric vector of years to filter assessments by publication year.}

\item{latest}{Optional. Logical. If \code{TRUE}, return only the latest assessment per species.}

\item{possibly_extinct}{Optional. Logical. Filter for species flagged as possibly extinct.}

\item{possibly_extinct_in_the_wild}{Optional. Logical. Filter for species possibly extinct in the wild.}

\item{scope_code}{Optional. Integer One or more scope codes to filter assessments.}

\item{page}{Optional. Integer vector. Specify one or more page numbers to fetch.
If \code{NULL} or \code{NA}, all pages will be fetched automatically.}
}
\value{
A tibble (class \code{tbl_df}, \code{tbl}, \code{data.frame}) where each column represents a unique API response JSON key.
If \code{code = NULL}, the tibble contains available threat categories with columns such as code and description.
If \code{code} is provided, the tibble contains assessment data for the specified threat(s), including threat description, threat code and year.
}
\description{
Retrieve species assessments based on threat categories.
If \code{code = NULL}, it returns a list of available threat categories.
If \code{code} is provided, it retrieves assessments for species affected by the specified threat(s).
}
\examples{
\dontrun{
# List all threat categories
rl_threats()

# Get species affected by agriculture & aquaculture threats (code 2)
rl_threats(code = 2)

# Get species affected by Climate change & severe weather threats published in 2025
rl_threats(
  code = "11",
  year_published = 2025
)
}
}
