% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incr.R
\name{decr}
\alias{decr}
\title{Decrease Value In Place}
\usage{
decr(x, by = 1)
}
\arguments{
\item{x}{object to be decreased; can be a symbol, character, or extraction language object.}

\item{by}{value to decrease \code{x} by; defaults to \code{1}.}
}
\value{
the value of \code{x} decreased by \code{by}, invisibly
}
\description{
Decrease the value of an object on the search path. Equivalent to \code{x--} or
\code{x -= by} in other languages. See \code{\link{incr}} for details on implementation.
}
\examples{
z <- 1:10

incr(z)
identical(z, 2:11)       # TRUE

incr(z[1:3], by=2)
identical(z[1:3], 4:6)   # TRUE

l <- list(a = 1, b = 2)
decr(l$a)
l$a == 0   # TRUE

decr(l$b, by = 4)
l$b == -2  # TRUE
}
