% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match.R
\name{iter.ref}
\alias{iter.ref}
\alias{iter.slice}
\alias{iter.rfexpr}
\title{Convert Reference to Iterable Object}
\usage{
\method{iter}{ref}(x)

\method{iter}{slice}(x)

\method{iter}{rfexpr}(x)
}
\arguments{
\item{x}{object to be looped across}
}
\value{
a vector
}
\description{
\code{\link{ref}} methods for use with \code{\link[eList]{iter}} in the \code{eList} package.
It allows \code{ref} objects to be used with the different vector comprehensions in the package
and with functions such as \code{\link[base]{lapply}} in base R.
}
\examples{
x <- sample(1:10, 5, replace=TRUE)
slice_x <- slice(x, 1:2)

lapply(eList::iter(slice_x), print)
}
