% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify.R
\name{modify_by}
\alias{modify_by}
\title{Modify an Object In Place}
\usage{
modify_by(x, value, ...)
}
\arguments{
\item{x}{object of class \code{"ref"}}

\item{value}{new value or function applied to the object at the referenced location}

\item{...}{additional arguments passed to the function}
}
\value{
object of class \code{"ref"}
}
\description{
Update the value pointed to by a \code{\link{ref}} object. If the new value is a function,
the old values will be applied to the function and overwritten.
}
\examples{
x <- 1:10
ref_to_x <- ref(x)

# Apply the square root function
modify_by(ref_to_x, sqrt)
print(x)

# Overwrite the original values
modify_by(ref_to_x, "hello world!")
print(x)

}
