% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refitME_package.r
\name{anova.refitME}
\alias{anova.refitME}
\title{An ANOVA function for fitted \code{refitME} objects}
\usage{
\method{anova}{refitME}(object, ..., dispersion = NULL, test = NULL)
}
\arguments{
\item{object}{: fitted model objects of class \code{refitME}.}

\item{...}{: further arguments passed through to \code{lm} or \code{glm}.}

\item{dispersion}{: the dispersion parameter for the fitting family. By default it is obtained from the object(s).}

\item{test}{: a character string, (partially) matching one of "\code{Chisq}", "\code{LRT}", "\code{Rao}", "\code{F}" or "\code{Cp}". See \code{\link{stat.anova}}.}
}
\value{
\code{anova.refitME} produces output identical to \code{anova.lm}, \code{anova.glm} or \code{anova.gam}.
}
\description{
An ANOVA function for fitted \code{refitME} objects.
}
\seealso{
\code{\link{anova}}
}
\author{
Jakub Stoklosa, Wen-Han Hwang and David I. Warton.
}
