% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poridge.R
\name{cmdscale_lanczos}
\alias{cmdscale_lanczos}
\title{Faster multi-dimensional scaling}
\usage{
cmdscale_lanczos(d, k = 2, eig = FALSE, add = FALSE, x.ret = FALSE)
}
\arguments{
\item{d}{a distance structure as returned by \code{{dist}}, or a full
symmetric matrix of distances or dissimilarities.}

\item{k}{the maximum dimension of the space which the data are to be
represented in; must be in \code{\{1, 2, ..., n-1\}}.}

\item{eig}{logical indicating whether eigenvalues should be returned.}

\item{add}{logical indicating if the additive constant of Cailliez (1983)
should be computed, and added to the non-diagonal dissimilarities such that
the modified dissimilarities are Euclidean.}

\item{x.ret}{indicates whether the doubly centred symmetric distance matrix
should be returned.}
}
\value{
as \code{{cmdscale}}
}
\description{
This is a modified version of \code{{cmdscale}} that uses the Lanczos
procedure (\code{[mgcv]{slanczos}}) instead of \code{eigen}. Called by
\code{{smooth.construct.pco.smooth.spec}}.
}
\references{
Cailliez, F. (1983). The analytical solution of the additive constant problem.
\emph{Psychometrika}, 48, 343-349.
}
\seealso{
\code{{smooth.construct.pco.smooth.spec}}
}
\author{
David L Miller, based on code by R Core.
}
