% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regexSelect.R
\name{regexSelect}
\alias{regexSelect}
\title{Create a selectize list input control with regular expression capabilities}
\usage{
regexSelect(input, output, session, data)
}
\arguments{
\item{input}{The input slot that will be used to access the value.}

\item{output}{The output variable to read the list of values returned be regex query}

\item{session}{The session of the shiny application}

\item{data}{reactive element contains a character vector where matches are sought, 
or an object which can be coerced by as.character to a character vector}
}
\value{
reactive character vector
}
\description{
Create a selectize list that can be used to choose a single or multiple 
items from a list of values with extension for regular expression.
}
\examples{
if(interactive()){
ui <- shiny::fluidPage(
regexSelectUI(id = "a", label = "Variable:",choices = names(iris)),
shiny::tableOutput("data")
)


ui.show <- shiny::fluidPage(
regexSelectUI(id = "a", label = "Variable:",choices = names(iris),checkbox.show = TRUE),
shiny::tableOutput("data")
)

server <- function(input, output, session) {
 curr_cols<-shiny::callModule(regexSelect, "a",shiny::reactive(names(iris)))
 
 shiny::observeEvent(curr_cols(),{
 cols_now<-curr_cols()
 if(length(cols_now)==0)  cols_now<-names(data())
 output$data <- shiny::renderTable({iris[,cols_now , drop = FALSE]}, rownames = TRUE)
 })
}

#do not show regex checkboxes
shiny::shinyApp(ui, server)

#show regex checkboxes
shiny::shinyApp(ui.show, server)
 }
}
