% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.rgam.R
\name{cv.rgam}
\alias{cv.rgam}
\title{Cross-validation for reluctant generalized additive model (rgam)}
\usage{
cv.rgam(x, y, lambda = NULL, family = c("gaussian", "binomial",
  "poisson", "cox"), offset = NULL, init_nz, gamma, nfolds = 10,
  foldid = NULL, keep = FALSE, parallel = FALSE, verbose = TRUE,
  ...)
}
\arguments{
\item{x}{Input matrix, of dimension \code{nobs x nvars}; each row is
an observation vector.}

\item{y}{Response \code{y} as in \code{rgam}.}

\item{lambda}{A user-supplied \code{lambda} sequence. Typical usage is to
have the program compute its own \code{lambda} sequence; supplying a value of
lambda overrides this.}

\item{family}{Response type. Either \code{"gaussian"} (default) for linear
regression, \code{"binomial"} for logistic regression, \code{"poisson"} for
Poisson regression or \code{"cox"} for Cox regression.}

\item{offset}{Offset vector as in \code{rgam}.}

\item{init_nz}{A vector specifying which features we must include when
computing the non-linear features. Default is to construct non-linear
features for all given features.}

\item{gamma}{Scale factor for non-linear features (vs. original features),
to be between 0 and 1. Default is 0.8 if \code{init_nz = c()}, 0.6 otherwise.}

\item{nfolds}{Number of folds for CV (default is 10). Although \code{nfolds}
can be as large as the sample size (leave-one-out CV), it is not recommended
for large datasets. Smallest value allowable is \code{nfolds = 4}.}

\item{foldid}{An optional vector of values between 1 and \code{nfolds}
identifying what fold each observation is in. If supplied, \code{nfolds} can
be missing.}

\item{keep}{If \code{keep = TRUE}, a prevalidated array is returned
containing fitted values for each observation at each value of lambda. This
means these fits are computed with this observation and the rest of its fold
omitted. Default is \code{FALSE}.}

\item{parallel}{If TRUE, use parallel foreach to fit each fold. Must
register parallel before hand, such as doMC or others. Note that this also
passes \code{parallel = TRUE} to the \code{rgam()} call within each fold.
Default is FALSE.}

\item{verbose}{Print information as model is being fit? Default is
\code{TRUE}.}

\item{...}{Other arguments that can be passed to \code{rgam}.}
}
\value{
An object of class \code{"cv.rgam"}.
\item{glmfit}{A fitted \code{rgam} object for the full data.}
\item{lambda}{The values of \code{lambda} used in the fits.}
\item{nzero_feat}{The number of non-zero features for the model \code{glmfit}.}
\item{nzero_lin}{The number of non-zero linear components for the model
\code{glmfit}.}
\item{nzero_nonlin}{The number of non-zero non-linear components for the
model \code{glmfit}.}
\item{fit.preval}{If \code{keep=TRUE}, this is the array of prevalidated
fits.}
\item{cvm}{The mean cross-validated error: a vector of length
\code{length(lambda)}.}
\item{cvse}{Estimate of standard error of \code{cvm}.}
\item{cvlo}{Lower curve = \code{cvm - cvsd}.}
\item{cvup}{Upper curve = \code{cvm + cvsd}.}
\item{lambda.min}{The value of \code{lambda} that gives minimum
  \code{cvm}.}
\item{lambda.1se}{The largest value of \code{lambda} such that the CV
  error is within one standard error of the minimum.}
\item{foldid}{If \code{keep=TRUE}, the fold assignments used.}
\item{name}{Name of error measurement used for CV.}
\item{call}{The call that produced this object.}
}
\description{
Does \code{k}-fold cross-validation for \code{rgam}.
}
\details{
The function runs \code{rgam} nfolds+1 times; the first to get the lambda
sequence, and then the remainder to compute the fit with each of the folds
omitted. The error is accumulated, and the average error and standard
deviation over the folds is computed.

Note that \code{cv.rgam} only does cross-validation for lambda but not for
the degrees of freedom hyperparameter.
}
\examples{
set.seed(1)
n <- 100; p <- 20
x <- matrix(rnorm(n * p), n, p)
beta <- matrix(c(rep(2, 5), rep(0, 15)), ncol = 1)
y <- x \%*\% beta + rnorm(n)

cvfit <- cv.rgam(x, y)

# specify number of folds
cvfit <- cv.rgam(x, y, nfolds = 5)

}
