% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_posdef.R
\name{check_posdef}
\alias{check_posdef}
\title{Check if a matrix is positive definite}
\usage{
check_posdef(M)
}
\arguments{
\item{M}{numeric matrix}
}
\value{
returns a named logical vector with the following elements:

\describe{
    \item{sqr}{logical: indicating whether \code{M} is square}
    \item{sym}{logical: indicating whether \code{M} is symmetric}
    \item{posdef}{logical: indicating whether \code{M} is positive-definitive}
}
}
\description{
Check if a matrix is positive definite
}
\details{
check if a matrix is 1) square, 2) symmetric, and 3) positive
definite
}
\examples{

# distance matrix
M = distm_scaled(expand.grid(x = 1:3, y = 1:3))

# check if it is positive definitive
check_posdef(M)

# check if the covariance matrix is positive definitive
check_posdef(covar_exp(M, .1))

# non-symmetric matrix
check_posdef(matrix(1:9, 3, 3))

# non-square matrix
check_posdef(matrix(1:6, 3, 2))

}
