% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invert_chol.R
\name{invert_chol}
\alias{invert_chol}
\title{Invert the cholesky decomposition of V}
\usage{
invert_chol(M, nugget = 0, ncores = NA)
}
\arguments{
\item{M}{numeric (double), positive definite matrix}

\item{nugget}{numeric (double) nugget to add to M}

\item{ncores}{optional integer indicating how many cores to use during the
inversion calculation}
}
\value{
numeric matrix: inverse of the Cholesky decomposition (lower triangle)
}
\description{
Invert the cholesky decomposition of V
}
\details{
Calculates the inverse of the Cholesky decomposition of M which
should not be confused with the inverse of M *derived* from the
Cholesky decomposition (i.e. `chol2inv(M)`).
}
\examples{
M <- crossprod(matrix(1:6, 3))

# without a nugget:
invert_chol(M)

# with a nugget:
invert_chol(M, nugget = 0.2)
}
