% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partitioned-GLS.R
\name{sample_partitions}
\alias{sample_partitions}
\title{Randomly sample a partition matrix for partitioned GLS}
\usage{
sample_partitions(
  npix,
  npart = 10,
  partsize = NA,
  pixels = NA,
  verbose = FALSE
)
}
\arguments{
\item{npix}{number of pixels in full dataset}

\item{npart}{number of partitions to create}

\item{partsize}{size of each partition}

\item{pixels}{vector of pixel indexes to sample from}

\item{verbose}{logical: TRUE prints additional info}
}
\value{
\code{sample_partitions} returns a matrix with \code{partsize}
rows and \code{npart} columns. Columns contain random, non-overlapping samples
from \code{1:npix}
}
\description{
Create a matrix whose columns contain indices of non-overlapping
random samples.
}
\details{
If both \code{npart} and \code{partsize} is specified, a partition matrix with
these dimensions is returned. If only \code{npart}, is specified,
\code{partsize} is selected as the largest integer possible  that creates
equal sized partitions. Similarly, if only \code{npart = NA}, then \code{npart}
is selected to obtain as many partitions as possible.
}
\examples{
# dummy data with 100 pixels and 20 time points
dat.M <- matrix(rnorm(100*20), ncol = 20)

# 4 partitions (exhaustive)
sample_partitions(npix = nrow(dat.M), npart = 4)

# partitions with 10 pixels each (exhaustive)
sample_partitions(npix = nrow(dat.M), partsize = 10)

# 4 partitions each with 10 pixels (non-exhaustive, produces warning)
sample_partitions(npix = nrow(dat.M), npart = 4, partsize = 10)

# index of 50 pixels to use as subset
sub.indx <- c(1:10, 21:25, 30:62, 70:71)

# 5 partitions (exhaustive) from only the specified pixel subset
sample_partitions(npix = nrow(dat.M), npart = 5, pixels = sub.indx)

}
\seealso{
Other partitionedGLS: 
\code{\link{MC_GLSpart}()},
\code{\link{crosspart_GLS}()}
}
\concept{partitionedGLS}
