% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rm_uvsum2.R, R/_old_uvsum_mvsum.R
\name{rm_uvsum}
\alias{rm_uvsum}
\title{Output several univariate models nicely in a single table}
\usage{
rm_uvsum(
  response,
  covs,
  data,
  digits = getOption("reportRmd.digits", 2),
  covTitle = "",
  caption = NULL,
  tableOnly = FALSE,
  removeInf = FALSE,
  p.adjust = "none",
  unformattedp = FALSE,
  whichp = c("levels", "global", "both"),
  chunk_label,
  gee = FALSE,
  id = NULL,
  corstr = NULL,
  family = NULL,
  type = NULL,
  offset = NULL,
  strata = 1,
  nicenames = TRUE,
  showN = TRUE,
  showEvent = TRUE,
  CIwidth = 0.95,
  reflevel = NULL,
  returnModels = FALSE,
  fontsize,
  forceWald = FALSE
)

rm_uvsum(
  response,
  covs,
  data,
  digits = getOption("reportRmd.digits", 2),
  covTitle = "",
  caption = NULL,
  tableOnly = FALSE,
  removeInf = FALSE,
  p.adjust = "none",
  unformattedp = FALSE,
  whichp = c("levels", "global", "both"),
  chunk_label,
  gee = FALSE,
  id = NULL,
  corstr = NULL,
  family = NULL,
  type = NULL,
  offset = NULL,
  strata = 1,
  nicenames = TRUE,
  showN = TRUE,
  showEvent = TRUE,
  CIwidth = 0.95,
  reflevel = NULL,
  returnModels = FALSE,
  fontsize,
  forceWald = FALSE
)
}
\arguments{
\item{response}{string vector with name of response}

\item{covs}{character vector with the names of columns to fit univariate
models to}

\item{data}{dataframe containing data}

\item{digits}{number of digits to round estimates and CI to. Does not affect
p-values.}

\item{covTitle}{character with the names of the covariate (predictor) column.
The default is to leave this empty for output or, for table only output to
use the column name 'Covariate'.}

\item{caption}{character containing table caption (default is no caption)}

\item{tableOnly}{boolean indicating if unformatted table should be returned}

\item{removeInf}{boolean indicating if infinite estimates should be removed
from the table}

\item{p.adjust}{p-adjustments to be performed. Uses the
\link{p.adjust} function from base R}

\item{unformattedp}{boolean indicating if you would like the p-value to be
returned unformatted (ie not rounded or prefixed with '<'). Should be used
in conjunction with the digits argument.}

\item{whichp}{string indicating whether you want to display p-values for
levels within categorical data ("levels"), global p values ("global"), or
both ("both"). Irrelevant for continuous predictors.}

\item{chunk_label}{only used if output is to Word to allow cross-referencing}

\item{gee}{boolean indicating if gee models should be fit to account for
correlated observations. If TRUE then the id argument must specify the
column in the data which indicates the correlated clusters.}

\item{id}{character vector which identifies clusters. Only used for geeglm}

\item{corstr}{character string specifying the correlation structure. Only used
for geeglm. The following are permitted: '"independence"', '"exchangeable"',
'"ar1"', '"unstructured"' and '"userdefined"'}

\item{family}{description of the error distribution and link function to be
used in the model. Only used for geeglm}

\item{type}{string indicating the type of univariate model to fit. The
function will try and guess what type you want based on your response. If
you want to override this you can manually specify the type. Options include
"linear", "logistic", "poisson",coxph", "crr", "boxcox", "ordinal", "geeglm"}

\item{offset}{string specifying the offset term to be used for Poisson or
negative binomial regression. Example: offset="log(follow_up)"}

\item{strata}{character vector of covariates to stratify by. Only used for
coxph and crr}

\item{nicenames}{boolean indicating if you want to replace . and _ in strings
with a space}

\item{showN}{boolean indicating if you want to show sample sizes}

\item{showEvent}{boolean indicating if you want to show number of events. Only
available for logistic.}

\item{CIwidth}{width of confidence interval, default is 0.95}

\item{reflevel}{manual specification of the reference level. Only used for
ordinal regression This will allow you to see which model is not fitting if
the function throws an error}

\item{returnModels}{boolean indicating if a list of fitted models should be
returned. If this is TRUE then the models will be returned, but the output
will be suppressed. In addition to the model elements a data element will be
appended to each model so that the fitted data can be examined, if
necessary. See Details}

\item{fontsize}{PDF/HTML output only, manually set the table fontsize}

\item{forceWald}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{forceWald = TRUE} is no longer supported; this function will always use profile likelihoods as per the inclusion of the MASS confidence intervals into base from from R 4.4.0}
}
\value{
A character vector of the table source code, unless tableOnly=TRUE in
which case a data frame is returned

A character vector of the table source code, unless tableOnly=TRUE in
which case a data frame is returned
}
\description{
#'A table with the model parameters from running separate univariate models on
each covariate. For factors with more than two levels a Global p-value is
returned.

A table with the model parameters from running separate univariate models on
each covariate. For factors with more than two levels a Global p-value is
returned.
}
\details{
Global p-values are likelihood ratio tests for lm, glm and polr models. For
lme models an attempt is made to re-fit the model using ML and if,successful
LRT is used to obtain a global p-value. For coxph models the model is re-run
without robust variances with and without each variable and a LRT is
presented. If unsuccessful a Wald p-value is returned. For GEE and CRR models
Wald global p-values are returned.

As of version 0.1.1 if global p-values are requested they will be included in
the p-value column.

The number of decimals places to display the statistics can be changed with
digits, but this will not change the display of p-values. If more significant
digits are required for p-values then use tableOnly=TRUE and format as
desired.

tidyselect can only be used for response and covs variables. Additional
arguments must be passed in using characters

Global p-values are likelihood ratio tests for lm, glm and polr models. For
lme models an attempt is made to re-fit the model using ML and if,successful
LRT is used to obtain a global p-value. For coxph models the model is re-run
without robust variances with and without each variable and a LRT is
presented. If unsuccessful a Wald p-value is returned. For GEE and CRR models
Wald global p-values are returned.

The number of decimals places to display the statistics can be changed with
digits, but this will not change the display of p-values. If more significant
digits are required for p-values then use tableOnly=TRUE and format as
desired.
}
\examples{
# Examples are for demonstration and are not meaningful
# Coxph model with 90\% CI
data("pembrolizumab")
rm_uvsum(response = c('os_time','os_status'),
covs=c('age','sex','baseline_ctdna','l_size','change_ctdna_group'),
data=pembrolizumab,CIwidth=.9)

# Linear model with default 95\% CI
rm_uvsum(response = 'baseline_ctdna',
covs=c('age','sex','l_size','pdl1','tmb'),
data=pembrolizumab)

# Logistic model with default 95\% CI
rm_uvsum(response = 'os_status',
covs=c('age','sex','l_size','pdl1','tmb'),
data=pembrolizumab,family = binomial)
# Poisson models returned as model list
mList <- rm_uvsum(response = 'baseline_ctdna',
covs=c('age','sex','l_size','pdl1','tmb'),
data=pembrolizumab, returnModels=TRUE)
#'
# GEE on correlated outcomes
data("ctDNA")
rm_uvsum(response = 'size_change',
covs=c('time','ctdna_status'),
gee=TRUE,
id='id', corstr="exchangeable",
family=gaussian("identity"),
data=ctDNA,showN=TRUE)

# Using tidyselect
pembrolizumab |> rm_uvsum(response = sex,
covs = c(age, cohort))
# Examples are for demonstration and are not meaningful
# Coxph model with 90\% CI
data("pembrolizumab")
rm_uvsum(response = c('os_time','os_status'),
covs=c('age','sex','baseline_ctdna','l_size','change_ctdna_group'),
data=pembrolizumab,CIwidth=.9)

# Linear model with default 95\% CI
rm_uvsum(response = 'baseline_ctdna',
covs=c('age','sex','l_size','pdl1','tmb'),
data=pembrolizumab)

# Logistic model with default 95\% CI
rm_uvsum(response = 'os_status',
covs=c('age','sex','l_size','pdl1','tmb'),
data=pembrolizumab,family = binomial)
# Poisson models returned as model list
mList <- rm_uvsum(response = 'baseline_ctdna',
covs=c('age','sex','l_size','pdl1','tmb'),
data=pembrolizumab, returnModels=TRUE)
#'
# GEE on correlated outcomes
data("ctDNA")
rm_uvsum(response = 'size_change',
covs=c('time','ctdna_status'),
gee=TRUE,
id='id', corstr="exchangeable",
family=gaussian("identity"),
data=ctDNA,showN=TRUE)
}
\seealso{
\code{\link{uvsum}},\code{\link{lm}},\code{\link{glm}},
\code{\link[cmprsk:crr]{cmprsk::crr}},
\code{\link[survival:coxph]{survival::coxph}},
\code{\link[nlme:lme]{nlme::lme}},
\code{\link[geepack:geeglm]{geepack::geeglm}},
\code{\link[MASS:glm.nb]{MASS::glm.nb}}

\code{\link{covsum}},\code{\link{fisher.test}},
\code{\link{chisq.test}}, \code{\link{wilcox.test}},
\code{\link{kruskal.test}}, \code{\link{anova}}, \code{\link[rstatix:cramer_v]{rstatix::cramer_v}},
\code{\link[rstatix:eta_squared]{rstatix:eta_squared}}, and \code{\link{outTable}}
}
