% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{RandomizedBlockDesignEffectSizes}
\alias{RandomizedBlockDesignEffectSizes}
\title{RandomizedBlockDesignEffectSizes}
\usage{
RandomizedBlockDesignEffectSizes(
  m1,
  std1,
  m2,
  std2,
  m3,
  std3,
  m4,
  std4,
  BE = 0,
  type = "n"
)
}
\arguments{
\item{m1}{The theoretical mean for the control group in Block 1}

\item{std1}{The theoretical variance for the control group in Block 1}

\item{m2}{The theoretical mean for the treatment group in Block 1}

\item{std2}{The theoretical variance for the treatment group in Block 1}

\item{m3}{The theoretical mean for the control group in Block 2}

\item{std3}{The theoretical variance for the control group in Block 2}

\item{m4}{The theoretical mean for the treatment group in Block 2}

\item{std4}{The theoretical variance for the treatment group in Block 2}

\item{BE}{A fixed block effect to be added to the Block 2 mean values.}

\item{type}{String identifying the distribution, 'n' for normal, 'ln' for lognormal, 'lap' for Laplace, 'g' for Gamma}
}
\value{
dataframe holing the expected unstandardized mean difference effect size, the pooled within group variance, the standardized effect size and the point bi-serial correlation.
}
\description{
This function finds the theoretical effect sizes for a four-group randomized block experiments assuming one of four different underlying distributions specified by the type parameter. The design assumes two blocks each comprising a control and treatment group. If required a fixed Blocking effect is added to the mean for Block 2.
}
\examples{
RandomizedBlockDesignEffectSizes(m1=0,std1=1,m2=1,std2=1,m3=0,std3=1,m4=1,
  std4=1,BE = 1,type = 'n')
# ES Var StdES      rPBS
#1  1   1     1 0.4472136
RandomizedBlockDesignEffectSizes(m1=0,std1=1,m2=1,std2=1,m3=0,std3=1,m4=1,
  std4=1,BE = 1,type = 'l')
#        ES      Var     StdES      rPBS
#1 5.266886 82.17791 0.5810004 0.2789675
RandomizedBlockDesignEffectSizes(
  m1=0,std1=1,m2=0.266,std2=1,m3=0,std3=1,m4=0.266,std4=1,BE = 0,type = 'l')
#        ES      Var     StdES       rPBS
#1 0.5024232 6.310995 0.1999957 0.09950162
}
\author{
Barbara Kitchenham and Lech Madeyski
}
