% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{api_query}
\alias{api_query}
\alias{api_query_}
\title{Query construction}
\usage{
api_query(.data, ...)

api_query_(.data, ..., .dots)
}
\arguments{
\item{.data}{Result of a call to \code{api}}

\item{...}{Comma separated list of unquoted variable names}

\item{.dots}{Used to work around non-standard evaluation}
}
\description{
Query construction
}
\examples{
\dontrun{
## NSE
api("http://api.plos.org/search") \%>\%
  api_query(q = ecology, wt = json, fl = 'id,journal') \%>\%
  peep

api("http://api.plos.org/search") \%>\%
  api_query(q = ecology, wt = json, fl = id, fl = journal) \%>\%
  peep

## SE
api("http://api.plos.org/search") \%>\%
  api_query_(q = "ecology", wt = "json", fl = 'id', fl = 'journal') \%>\%
  peep

## NSE
api("http://api.plos.org/search") \%>\%
  api_query(q = ecology, wt = json, fl = 'id,journal')
## SE
api("http://api.plos.org/search") \%>\%
  api_query_(q = "ecology", wt = "json", fl = 'id', fl = 'journal')
}
}
\seealso{
Other dsl: \code{\link{api_body}},
  \code{\link{api_config}},
  \code{\link{api_error_handler}}, \code{\link{api}},
  \code{\link{auth}}
}

