% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_distributions.R
\name{plot_distributions}
\alias{plot_distributions}
\title{Plot several distributions}
\usage{
plot_distributions(
  ...,
  distributions = list(),
  .x,
  plots = c("density", "probability", "hazard"),
  with_params = list(),
  as_list = FALSE
)
}
\arguments{
\item{...}{distribution objects (must be named)}

\item{distributions}{Named list of distribution objects.
This is concatenated with \code{...}.}

\item{.x}{Numeric vector of points to evaluate at.}

\item{plots}{Plots to be created. May be abbreviated.
The plots will be stacked in the order given from top to bottom.}

\item{with_params}{list of distribution parameters to be given to each
distribution using \code{with_params}. If named, the names are matched to the
distribution names. Otherwise, they are allocated positionally, index 1
corresponding to the first element of \code{distributions}, then all other
elements from \code{distributions} followed by the arguments in \code{...} in order.}

\item{as_list}{return a list of ggplots instead of a patchwork?}
}
\value{
A stacked patchwork of the requested ggplots
}
\description{
Plot several distributions
}
\examples{
rate <- 1
x <- rexp(20, rate)
d_emp <- dist_empirical(x, positive = TRUE)
d_exp <- dist_exponential()
plot_distributions(
  empirical = d_emp,
  theoretical = d_exp,
  estimated = d_exp,
  with_params = list(
    theoretical = list(rate = rate),
    estimated = list(rate = 1 / mean(x))
  ),
  .x = seq(1e-4, 5, length.out = 100)
)
}
