% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.reslr_output.R
\name{print.reslr_output}
\alias{print.reslr_output}
\title{Print a reslr output object which is created by the \code{reslr_mcmc} function.}
\usage{
\method{print}{reslr_output}(x, ...)
}
\arguments{
\item{x}{An object of class \code{reslr_output}}

\item{...}{Other arguments (not supported)}
}
\value{
Returns high level information about the reslr_output object, i.e. the number of iterations and chains used.
}
\description{
This will be very high level printing that the user can use to obtain information about the MCMC run using JAGS. The number of iterations and chains used by the user is printed
In addition, the type of statistical model is printed.
}
\examples{
\donttest{
data <- NAACproxydata \%>\% dplyr::filter(Site == "Cedar Island")
input_data <- reslr_load(data = data)
jags_output <- reslr_mcmc(input_data = input_data, model_type = "eiv_slr_t")
print(x = jags_output)}

}
