% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reslr_mcmc.R
\name{reslr_mcmc}
\alias{reslr_mcmc}
\title{Run a \code{reslr_input} object through the main reslr Markov chain Monte Carlo (MCMC) function using a chosen statistical model}
\usage{
reslr_mcmc(
  input_data,
  model_type,
  n_cp = 1,
  igp_smooth = 0.2,
  n_iterations = 5000,
  n_burnin = 1000,
  n_thin = 4,
  n_chains = 3,
  CI = 0.95,
  spline_nseg = NULL,
  spline_nseg_t = 20,
  spline_nseg_st = 6
)
}
\arguments{
\item{input_data}{Input data from the \code{reslr_load} function}

\item{model_type}{The user selects their statistical model type. The user can select a Errors in Variable Simple Linear Regression using "eiv_slr_t". The user can select a Errors in Variable Change Point Regression using  "eiv_cp_t". The user can select a Errors in Variable Integrated Gaussian Process using "eiv_igp_t". The user can select a Noisy Input Spline in Time using "ni_spline_t". The user can select a Noisy Input Spline in Space Time using "ni_spline_st". The user can select a Noisy Input Generalised Additive Model using "ni_gam_decomp".}

\item{n_cp}{This setting is focused on the Errors in Variables Change Point model. The user can select the number of change points 1,2 or 3.}

\item{igp_smooth}{This setting is focused on the Errors in Variables Integrated Gaussian Process model. It informs the prior for the smoothness (correlation) parameter if model = "igp" is chosen. Choose a value between 0 and 1. Closer to 1 will increase smoothness.}

\item{n_iterations}{Number of iterations. Increasing this value will increase the computational run time.}

\item{n_burnin}{Size of burn-in. This number removes a certain number of samples at the beginning.}

\item{n_thin}{Amount of thinning.}

\item{n_chains}{Number of MCMC chains. The number of times the model will be run.}

\item{CI}{Size of the credible interval required by the user. The default is 0.95 corresponding to 95\%.}

\item{spline_nseg}{This setting is focused on the Noisy Input Spline model. It provides the number of segments used to create basis functions.}

\item{spline_nseg_t}{This setting is focused on the Noisy Input Generalised Additive Model. It provides the number of segments used to create basis functions.}

\item{spline_nseg_st}{This setting is focused on the Noisy Input Generalised Additive Model. It provides the number of segments used to create basis functions.}
}
\value{
A list containing the input data, the JAGS output and output dataframes used for final plots.
}
\description{
In this function, a variety of statistical models can be run depending on the requirements of the user. All models are written within a Bayesian framework and use JAGS (Just Another Gibbs Sampler) to calculate Markov Chain Monte Carlo (MCMC) simulation to obtain estimates of unknown parameters. The user has the ability to alter the number of iterations, the number of burnin, the number of chains and the thinning. These options relate to the amount of MCMC simulations required and should be reviewed by the user to ensure model convergence is achieved without excessively long run times.
The user chooses their 'model_type' and as a range of models to choose from.
}
\examples{
\donttest{
data <- NAACproxydata \%>\% dplyr::filter(Site == "Cedar Island")
input_data <- reslr_load(data = data)
reslr_mcmc(input_data = input_data, model_type = "eiv_slr_t")}
}
