% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.reslr_output.R
\name{summary.reslr_output}
\alias{summary.reslr_output}
\title{Produces summaries and convergence diagnostics for an object created with \code{\link{reslr_mcmc}}.}
\usage{
\method{summary}{reslr_output}(object, ...)
}
\arguments{
\item{object}{Output object from the \code{\link{reslr_mcmc}}}

\item{...}{Not in use}
}
\value{
A list containing convergence diagnostics and parameter estimates for the output.
}
\description{
A warning message will appear if the model has not been converge. If this appears the user is recommended to re-run the model and alter the \code{reslr_mcmc} function default iteration and MCMC settings. Also, it provides high-level summaries of the estimated parameters.
}
\examples{
\donttest{
data <- NAACproxydata \%>\% dplyr::filter(Site == "Cedar Island")
input_data <- reslr_load(data = data)
jags_output <- reslr_mcmc(input_data = input_data, model_type = "eiv_slr_t")
summary(object = jags_output)}
}
